/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_4730;
import team.chisel.ctm.api.client.CTMTexture;
import team.chisel.ctm.api.client.TextureInfo;
import team.chisel.ctm.client.CTMClient;
import team.chisel.ctm.client.resource.CTMMetadataSection;
import team.chisel.ctm.client.texture.type.TextureTypeNormal;
import team.chisel.ctm.client.util.ResourceUtil;

public class TextureUtil {
    public static Map<class_2960, CTMTexture<?>> initializeTextures(Set<class_4730> textureDependencies, Function<class_4730, class_1058> spriteGetter) {
        HashMap textures = new HashMap();
        TextureUtil.initializeTextures(textureDependencies, textures, spriteGetter);
        return textures;
    }

    public static void initializeTextures(Set<class_4730> textureDependencies, Map<class_2960, CTMTexture<?>> textures, Function<class_4730, class_1058> spriteGetter) {
        for (class_4730 identifier : textureDependencies) {
            class_1058 sprite = spriteGetter.apply(identifier);
            CTMMetadataSection metadata = ResourceUtil.getMetadataSafe(sprite);
            if (metadata == null) continue;
            textures.put(sprite.method_4598(), TextureUtil.makeTexture(metadata, sprite, spriteGetter));
        }
    }

    public static CTMTexture<?> makeTexture(CTMMetadataSection metadata, class_1058 sprite, Function<class_4730, class_1058> spriteGetter) {
        if (metadata.getProxy() != null) {
            try {
                class_1058 proxySprite = spriteGetter.apply(TextureUtil.toSpriteIdentifier(metadata.getProxy()));
                CTMMetadataSection proxyMetadata = ResourceUtil.getMetadata(proxySprite);
                if (proxyMetadata == null) {
                    return TextureUtil.makeDefaultTexture(proxySprite);
                }
                sprite = proxySprite;
                metadata = proxyMetadata;
            }
            catch (Exception e) {
                CTMClient.LOGGER.error("Could not load metadata of proxy sprite " + metadata.getProxy() + ". Ignoring proxy and using base texture.", (Throwable)e);
            }
        }
        class_2960[] textures = metadata.getAdditionalTextures();
        int provided = textures.length + 1;
        int required = metadata.getType().requiredTextures();
        class_1058[] sprites = new class_1058[required];
        sprites[0] = sprite;
        for (int i = 1; i < required; ++i) {
            class_2960 identifier = null;
            if (i < provided) {
                identifier = textures[i - 1];
            }
            sprites[i] = spriteGetter.apply(TextureUtil.toSpriteIdentifier(identifier));
        }
        return metadata.getType().makeTexture(new TextureInfo(sprites, metadata.getBlendMode(), Optional.ofNullable(metadata.getExtraData())));
    }

    public static CTMTexture<?> makeDefaultTexture(class_1058 sprite) {
        return TextureTypeNormal.INSTANCE.makeTexture(new TextureInfo(new class_1058[]{sprite}, null, Optional.empty()));
    }

    public static class_4730 toSpriteIdentifier(class_2960 identifier) {
        return new class_4730(class_1059.field_5275, identifier);
    }

    public static boolean isTextureReference(String texture) {
        return texture.charAt(0) == '#';
    }
}

